# -*- coding: utf-8 -*-
"""
Created on Mon Oct 16 08:19:31 2017

@author: gerd doeben-henisch
Extend the program gdh-win10.py by a timer-mechanism for automatic
continuation of the event-loop
"""

# Program: gdh-win12b.py

def main():
   import graphics as grph        #Graphics objects from Zelle
   import environment as env      #Functions to generate grids
   import numpy as np             #numerical library numpy
   import acctor as acc           #Acctor related functions
   import time as tm              #Timer library
   
   ##
   ## SET UP THE ENVIRONMENT
   ##
   
   e1=env.ENVOBJ('env1',0)
   
   xmax = 700
   ymax = 700
   
   win = grph.GraphWin('ENVIRONMENT 1', xmax, ymax)
   win.setBackground('HoneyDew')
   

   first = 1    #First element of the list
   last = 7     # Last element of the list used
   distance = 100   #distance of two lines in the grid
   maxXcoord = 7  #size of the data array in the background
   maxYcoord = 7
   nobj = 20    #objects: percentage of the array space !
   nfood = 1    #food: percentage of the array space !
   
   #generating the lines of the grid
   
   env.grid(win,xmax, ymax, first, last, distance)
   
  # Fill the grid with spaces and objects
   gr2=env.fillgridobj2(win,first, last, maxXcoord,maxYcoord,nobj)
   
   # Fill the grid with food
   gr2=env.fillgridfood(win,first, last, maxXcoord,maxYcoord,nfood,gr2)
   
   # Introducing an actor for the event-loop
   
   time=e1.getClock()  #Setting the time of 'birth'
   
   #Get the array coordinates for the actor
   message = grph.Text(grph.Point(80, 15), "Click on one point")
   message.draw(win)

    # Get and draw the coordinate of a point
   p = win.getMouse()
   p.draw(win)
   xc=p.getX()
   yc=p.getY()
   print('P ',p,(xc,yc))
    
   #Transform the window coordinates into the array coordinates
   xs = int(xc/100)
   ys = int(yc/100) 
   x = xs+1
   y=ys+1
   print('Center Array  ',(x,y))
   
   #Insert the actor in the data array
   gr2[xs,ys]=3
   
   #Introduce more parameter
   dir=1
   color = 'red'
   name="A1"
   energy=2000
   energyrate=2
   
   #Generate an instance of the actor class ACTOBJ
   a1=acc.ACTOBJ(name,time,x,y,dir,color, energy,energyrate)

   a1.setPos(x,y)
   outputMessage='yesMove'  #This tells the environment whether an actor
                           #wants to move
   a1.setOutputMessage(outputMessage)
   
   #Realize an actor on the window
   env.introduceActor(x,y,dir,name,color,energy,distance,win)
   
   print('MAP OF ARRAY \n')
   print(str(gr2))
   print('ATTENTION: Columns represent Rows on screen!\n')
   
   ##
   ## START AN EVENT LOOP FOR THE ENVIRONMENT
   ##
   ## ASK ACTOR-BEHAVIOR-FUNCTION WHAT TO DO
   ## CHECK WETHER ACTIONS WANTED ARE POSSIBLE
   ## MODIFY THE ENVIRONMENTR IF NECESSARY
   ## REPEAT AS LONG AS ACTORS ARE ALIVE
   ##
   
   # condition for while
   
   FINISH=100

   while FINISH >0:

    # Look to the actor class for new responses
    
     dir=a1.getDir()
     print('Direction = ', dir)
     p=a1.getPos()
     print('Actual Position = ',p)
     xold=p[0]
     yold=p[1]
    
     if a1.getOutputMessage() == 'yesMove':
    
    # If there are responses then compute the next possible move
    
        Err, xnew, ynew = env.newPosition(dir,xold,yold)
        print('Err = ', Err)
        print('New Position planned = ', (xnew,ynew))
    
        #Check whether this new position  is possible
    
        if gr2[xnew-1,ynew-1] != 0:
            #Telling the actor that the planned new position is occupied
            a1.setInputMessage("NoMove")
            print('actor =',name,' has not moved')
        else:
            type=3 #actor
            #First change position in data array
            env.moveArray(type,xold,yold,xnew,ynew,gr2)
            #Tell the actor his new position
            a1.setPos(xnew,ynew)
            #Next change position in window
            env.introduceActor(xnew,ynew,dir,name,color,energy,distance,win)
            env.deleteActor(p,win)
     else:
        print('No move wanted by actor.')
        
    # Get the actual environment time
    
     t2=e1.getClock()
     print('Environment Time =', t2)

    #Call the actor
    
     acc.behaviorAc(e1,a1)
 
    
    # The actor will compute it's response and will update the class
   
    #counting FINISH down for to stop after finitely many steps
     FINISH=FINISH-1
    
     envClock = e1.getClock()
     print('Actual Environment Time = ',envClock)
     envClock= envClock+1
     e1.setClock(envClock)
     print('New  Environment Time = ',envClock)
    
     energy=a1.getEnergy()
     if energy <0:
        print('ATTENTION: Actor ',name,' has no more Energy!!!')
        FINISH=-1

    #Continuation delayed by the timer functionm
     tm.sleep(2) #python timer , sleep 5 secs
    
   
   print('THE GAME SAYS GOODBYE!')
   tm.sleep(10)
   win.close()
main()
