# -*- coding: utf-8 -*-
# environment.py
# author: Gerd Doeben-Henisch
# Collection of functions to support simple enviroments
# Using book from John Zelle (2002) and his simple graphics.py library

class ENVOBJ:
    
    def __init__(self,name,clock):
    
        self.name = name
        self.clock = clock
    
    def getName(self):
        return self.name
    
    def setName(self,name):
         self.name = name
         
    def getClock(self):
        return self.clock
    
    def setClock(self,clock):
         self.clock = clock
         
         

def grid(win,xmax,ymax,first,last,distance):
    
   import graphics as grph
   import numpy as np
   
   lx=list(range(first,last+1))
   linex = grph.Line(grph.Point(0,0), grph.Point(0,ymax-1))
     
   for i in range(first,last):     
       lx[i]=linex.clone()
       lx[i].move(i*distance,0)
       lx[i].draw(win)
       print(i)
       
   ly=list(range(first,last+1))    
   liney = grph.Line(grph.Point(0,0), grph.Point(xmax-1,0))
   
   for i in range(first,last):     
       ly[i]=liney.clone()
       ly[i].move(0,i*distance)
       ly[i].draw(win)
       print(i)
      

    

         
def fillgridobj(win,first, last, xmax,ymax):
    import graphics as grph
    import numpy as np
    
    # Generate a matrix with a random distribution of '0' and '1'.
    gr2=np.random.randint(2, size=(last,last))
    
    print('MAP OF ARRAY \n')
    print(str(gr2))
    print('ATTENTION: Columns represent Rows on screen!\n')
    
    for y in range(0,7):
        for x in range(0,7):
            if gr2[x,y] == 1:
               print(x+1,y+1)
               rect1 = grph.Rectangle(grph.Point(x*100,y*100), grph.Point((x+1)*100,(y+1)*100)) 
               rect1.setFill('black')
               rect1.draw(win)
              
    return gr2

def fillgridobj2(win,first, last, maxXcoord,maxYcoord,nobj):
 
    #nobj gives the percentage how many  objects shall be inserted into the matrix
    
    import graphics as grph
    import numpy as np
    
    #Compute number of wanted objects by percentage
    
    number=int(((maxXcoord*maxYcoord)/100)*nobj)
    if number <1:  
        number=1
         
    gr2=np.zeros((maxXcoord,maxYcoord),int)
    
    # Produce randomly the coordinates of the wanted objects
    
    for i in range(1,number):
        p=np.random.randint(first,last+1,size=2) #coordinates for the fillgridobj
        print(p)
        
        gr2[p[0]-1,p[1]-1]=1    # Set a marker in the data array
        x=p[0]-1
        y=p[1]-1
        
        #translating the fillgridob coordinates into the graphics coordinates 
        
        rect1 = grph.Rectangle(grph.Point(x*100,y*100), grph.Point((x+1)*100,(y+1)*100)) 
        rect1.setFill('black')
        rect1.draw(win)
        
    print('MAP OF ARRAY \n')
    print(str(gr2))
    print('ATTENTION: Columns represent Rows on screen!\n')
        
    return gr2        


               
def fillgridfood(win,first,last, maxXcoord,maxYcoord,nfood,gr2):
    
    #n gives the numer of food inserted into the matrix
    
    import graphics as grph
    import numpy as np
    
    number=int(((maxXcoord*maxYcoord)/100)*nfood)
    if number <1:  
        number=1


    for i in range(1,number+1):
        p=np.random.randint(first,last+1,size=2) #coordinates for the fillgridobj
        print(p)
        gr2[p[0]-1,p[1]-1]=2
        #translating the fillgridob coordinates into the graphics coordinates
        rect1 = grph.Rectangle( grph.Point( (p[0]-1)*100,(p[1]-1)*100 ),grph.Point( p[0]*100,p[1]*100) )
        rect1.setFill('green')
        rect1.draw(win)
        
    print('OBSTACLES with FOOD \n')
    
    # This conversion shows a matrix whose columns correspond to the
    # rows of the original matrix !
    
    gr2s=str(gr2)
    print(gr2s)
    print('anders \n')
    
    #This conversion shows rows after the conversion which correspnd
    #to the columns in the original array !
    
    gprint(gr2,last)

    return gr2

def gprint(a,lasty):
    
    #This conversion shows rows after the conversion which correspnd
    #to the columns in the original array !
    
    import numpy as np
    
    s=""
    for i in range(0,a.size):
        s=s+str(a.item(i))
        
    print(s)
        
    for j in range(0,lasty):
        print('\n ', s[(j*lasty):(j*lasty)+7])
        

    
    
def introduceActor(x,y,dir,name,color,energy,distance,win):
    
    # Convert array coordinates (x,y) into window coordinates (xwin,ywin)
    import numpy as np
    import graphics as grph
        
    rect1 = grph.Rectangle(grph.Point(x*100,y*100), grph.Point((x+1)*100,(y+1)*100)) 
    rect1.setFill('HoneyDew')
    rect1.draw(win)
    
    #insert act or
    xwin = ((x-1)*distance)+(distance/2)
    ywin = ((y-1)*distance)+(distance/2)
    
    #gnerate a red circle
    center = grph.Point(xwin,ywin)
    circ = grph.Circle(center, distance/2)
    circ.setFill(color)
    circ.draw(win)
    
    #gnerate a name as a lable 
    label = grph.Text(center, name)
    label.draw(win)
    
#Delete an actor on a certain position in the window
    
def deleteActor(p,win):
    
    # Convert array coordinates (x,y) into window coordinates (xwin,ywin)
    import numpy as np
    import graphics as grph
    
    x=p[0]-1
    y=p[1]-1
        
    #translating the fillgridob coordinates into the graphics coordinates 
        
    rect1 = grph.Rectangle(grph.Point(x*100,y*100), grph.Point((x+1)*100,(y+1)*100)) 
    rect1.setFill('HoneyDew')
    rect1.draw(win)
    
#Move to new position in data array
    
def moveArray(type,xold,yold,xnew,ynew,gr2):
    import numpy as np
    gr2[xold-1,yold-1]=0
    gr2[xnew-1,ynew-1]=type
    print('Type =',type,' has moved to',(xnew,ynew))
    
    
# Compute a new position starting with an old position and a direction
    
def newPosition(dir,xold,yold):
    
    xnew=xold
    ynew=yold
    Err=0
    
    if dir == 1:
        if yold-1 < 1:
            ynew = yold
        else:
            ynew=yold-1
    elif dir == 2:
        if xold+1 > 7:
            xnew = xold
        else:
            xnew=xold+1
    elif dir == 3:
        if yold+1 > 7:
            ynew = yold
        else:
            ynew=yold+1
    elif dir == 4:
        if xold-1 < 1:
            xnew = xold
        else:
            xnew=xold-1
    else:
        print('ERROR : Wrong Direction ! ')
        Err=-1
    
    return Err, xnew, ynew
        
        
            


          
            
            
            
            
        
        
        
               
               
               
    
         
         
         
        
        






