# -*- coding: utf-8 -*-
# actor.py
# author: Gerd Doeben-Henisch
# Collection of functions to support simple actors


        
class ACTOBJ:
    #The actor object has more propeties as a simple environment object.
    
    def __init__(self,name,time,x,y,dir,color, energy,energyrate):
        self.name = name
        self.time = time
        self.position = (x,y)
        self.dir = dir
        self.color = 'red'
        self.energy = energy
        self.energyrate = energyrate
        
    def getName(self):
        return self.name
    
    def setName(self,name):
        #This should be a short name different from others; a number 
        # is enough ...         
        self.name = name
        
    def getTime(self):
        return self.time
    
    def setTime(self,time):
        #The time will be derived  from the environment time
         self.time = time

    def getPos(self):
        # This is the position in the data array with simple (x,y) coordinates
        return self.position

    def setPos(self,x,y):
        # This is the position in the data array with simple (x,y) coordinates
        # The array counts from 0 ... n-1
        # The user counts from 1 ... n
         self.position = (x,y)
    
    def setDir(self,dir):
        # There are four basic directions as {1,2,3,4}
        self.dir = dir
        
    def getDir(self):
        # There are four basic directions as {1,2,3,4}
        return self.dir 
         
    def getColor(self):
        # All actors have the color red (for now; perhaps more later)
        return self.color
    
    
    def setColor(self,incolor):
         # All actors have the color red (for now; perhaps more later)
         self.color = incolor
    
    def setEnergy(self,energy):
        # Show actual energy level
        self.energy = energy
    
    def getEnergy(self):
        # Show actual energy level
        return self.energy
    
    def setEnergyRate(self,energyrate):
        # Show actual energy level
        self.energyrate = energyrate
    
    def getEnergyRate(self):
        # Show actual energy level
        return self.energyrate    

         
    def setInputMessage(self,inputMessage):
        #Some message from the environment
        self.inputMessage=inputMessage
        
    def getInputMessage(self):
        return  self.inputMessage
        
    def setOutputMessage(self,outputMessage):
        #Some message to the environment
        self.outputMessage=outputMessage
        
    def getOutputMessage(self):
        return  self.outputMessage
    
    
def behaviorAc(e,a):
    
    import numpy as np
    import environment as env
    import acctor as acc
    
    #BODY PART
    # Compute time since last call and change energy level
    
    name = a.getName()
    t1 = a.getTime()
    t2 = e.getClock()
    erate = a.getEnergyRate()
    ener = a.getEnergy()
    
    dt = t2-t1
    energynew = ener - (erate * dt)
    a.setEnergy(energynew)
    
    print('Actor ',name,' has new energy level = ',energynew)
    
    #MENTAL PART
    # Determine the new direction
    
    dirspace = 4
    dirnew = np.random.randint(1,dirspace+1)
    a.setDir(dirnew)
    print('New direction of actor ',name, ' is = ',dirnew)
    
    a.setOutputMessage('yesMove')
    print('actor ',name, 'wants to move')
    
    
        
    